//#include <stdio.h>
#include "font_8x8.h"

#define LINUX_TEXTADDR	0xc0048000
#define LINUX_MACHTYPE	60

#define LCD_NEXTLINE 160
#define LCD_ROWS 240

#define CHARLINES 8
#define CHAR_WIDTH 2
#define LCDSTART        0xc000d020

#define IO_MEM		0x80000000

#define LCD_MEM_START	0xc000d000
#define LCD_PAL_START	LCD_MEM_START

#define LCDOUT_8_BYTES(offset, dat) (*(volatile char *)(LCDSTART + (offset)) = dat)

#define readb(p)	(*(volatile char *)(IO_MEM + (p)))
#define writeb(v,p)	(*(volatile char *)(IO_MEM + (p)) = v)
#define readl(p)	(*(volatile int *)(IO_MEM + (p)))
#define writel(v,p)	(*(volatile int *)(IO_MEM + (p)) = v)

#define PCDR		(0x0e08)
#define PCDR_LIGHT	(1 << 4)
#define PCDR_UART2      (1 << 3)

#define PDDR		(0x0e0c)
#define PDDR_LCD	(1 << 2)

#define LCDCTL		(0x0200)
#define LCDCTL_EN	(1 << 0)
#define LCDCTL_BW	(1 << 1)

#define LCD_DBAR1	(0x0210)
#define LCDT0		(0x0220)
#define LCDT1		(0x0224)
#define LCDT2		(0x0228)
#define LCDT0_VAL	(0x1010a70)	/* LCD timing 0 */
#define LCDT1_VAL	(0x10108ef)	/* LCD timing 1 */
#define LCDT2_VAL	(0xb0b)		/* LCD timing 2 */

#define UART2_BASE	(0x0700)
#define UARTCON		(0x0c)
#define UARTEN		(1 << 0)

#define UARTFR		(0x10)
#define UARTINTM	(0x18)
#define UARTFCR		(0x4)
#define UARTBR		(0x8)

#define RXINT		(1 << 0)
#define TXINT		(1 << 1)
#define MSINT		(1 << 2)
#define UBUSY		(1 << 3)
#define BAUD_MASK	((1 << 16) - 1)

#define EIGHT		(3 << 5)
#define ONE		(1 << 3)

#define DIV_115200	0x3

#define readuartb(p)	readb(p + UART2_BASE)
#define writeuartb(v,p)	writeb(v, UART2_BASE + p)
#define readuartl(p)	readl(p + UART2_BASE)
#define writeuartl(v,p)	writel(v, UART2_BASE + p)

extern void dbgchr(int offset, char c);
extern void hogcpu();
extern void reboot(void);
extern void bootlinux(unsigned* textaddr, int arch);
extern void flush_v3(void);
extern void flush_v4(void);

static void sleep(int seconds) {
	int i;
	for (i = 0; i < seconds; i++) {
		hogcpu();
	}
}

unsigned bi_reverse(code, len) 
unsigned code; /* the value to invert */
int len;       /* its bit length */
{
	register unsigned res = 0;
	do {
		res |= code & 1;
		code >>= 1, res <<= 1;
	} while (--len > 0);
	return res >> 1;  
}

void clean_scr() {
	int i;
	int loc = 0;
	int line = 0;
	int linepos = 0;
	char blank_line = 0x0;
	int half_words_to_clear = (LCD_ROWS * LCD_NEXTLINE);
	for (i = 0; i < half_words_to_clear; ++i) {
		++linepos;
		if (linepos > LCD_NEXTLINE) {
			++line;
			loc = (line * LCD_NEXTLINE);
			linepos = 1;
		}
		LCDOUT_8_BYTES (loc, (~(bi_reverse(blank_line, 8))));
		++loc;
	}
}

void print_ch(int offset, char ch) {
	int i, temp;
	int fontpos;
	char ch_line;
	fontpos = (ch * CHARLINES);
	for (i=0; i < CHARLINES; ++i) {
		ch_line = fontdata_8x8[fontpos];
		LCDOUT_8_BYTES ((offset + (i*LCD_NEXTLINE)), (~(bi_reverse(ch_line, 8))));
		++fontpos;
	}
}

int setup_uart() {
	// Flush output
	while (readuartl(UARTFR) & UBUSY) {
	}

	// Turn on the port
	writel(readl(PCDR) | PCDR_UART2, PCDR);
	writeuartl(readuartl(UARTCON) | UARTEN, UARTCON);
	writeuartl(readuartl(UARTINTM) | TXINT | RXINT | MSINT, UARTINTM);
	
	// Set 8-N-1, no FIFO buffer
	writeuartb(EIGHT | ONE, UARTFCR);
	
	// Set baud rate 115200
	writeuartl(DIV_115200, UARTBR);
}

int uartputch(const char ch) {
	while (readuartl(UARTFR) & UBUSY) {
	}

	writeb(ch, UART2_BASE);

	if (ch == '\n') {
		uartputch('\r');
	}
}

int uartprint(const char *str) {
	while(*str) {
		uartputch(*str++);
	}
}

#if 0
int setup_lcd() {
	const int bpp = 2;
	int regno, val, nxt;

	writeb(readl(PCDR) | PCDR_LIGHT, PCDR);

	// Power
	writeb(readb(PDDR) | PDDR_LCD, PDDR);
	writel(readl(LCDCTL) | LCDCTL_EN, LCDCTL);

	// Disable
	writel(readl(LCDCTL) & ~LCDCTL_EN, LCDCTL);

	// Mem address
	writel(LCD_MEM_START, LCD_DBAR1);

	// Settings
	writel(LCDT0_VAL, LCDT0);
	writel(LCDT1_VAL, LCDT1);
	writel(LCDT2_VAL, LCDT2);

	// Enable
	writel(readl(LCDCTL) | LCDCTL_BW | LCDCTL_EN, LCDCTL);

	// Populate the 2bpp palette
	for (regno = 0; regno < 16; regno = regno + 2) {
		switch (regno) {
		case 0:
			val = 0xf;
			nxt = 0xa;
		case 2:
			val = 0x5;
			nxt = 0x0;
		default:
			val = 0x0;
			nxt = 0x0;
		}
		  
		if (regno == 0) {
			val |= ((bpp >> 1) << 12);
		}
		val = (val << 16);
		val = val | nxt;
		*(volatile int *) (LCD_PAL_START + regno * 2) = val;
	}
}
#endif

int main(void) {

	int i;
	char temp;
	int loc = 0;
	int line = 0;
	int linepos = 0;

	setup_uart();
	uartprint("\nPsion proboot running\n");

	//setup_lcd();
	//clean_scr();

	bootlinux((unsigned int *)LINUX_TEXTADDR, LINUX_MACHTYPE);	/* See init.S */
}


