/*
 * init.S --	Startup code for proboot.c.
 * 
 * Copyright (C) 2002 Tony Lindgren <tony@atomide.com>
 * 
 * Modeled after Ben Williamson's SRAM boot loader 
 * Original version Copyright (C) 1999 Ben Williamson <benw@pobox.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define RAM_BASE	0xc0000000	/* Start of the memory */
#define RAM_SIZE	0x00000800

.text

	.global _start
_start:
	mov	sp, #RAM_BASE
	add	sp, sp, #RAM_SIZE	// stack in RAM
	mov     r0, #0
	ldr	r1, =__bss_start	// clear bss
1:	str	r0, [r1], #4
	cmp	r1, sp
	blo	1b

	bl	main			/* see proboot.c */
2:	b	2b

	.global flush_v3
flush_v3:
	mov     r0, #0
	mcr     p15, 0, r0, c7, c7, 0	/* flush v3/v4 cache */
	mcr	p15, 0, r0, c5, c0, 0	/* flush v3 TLB */
	mov	pc, lr


	.global flush_v4
flush_v4:
	mov     r0, #0
	mcr     p15, 0, r0, c7, c7, 0	/* flush v3/v4 cache */
	mcr	p15, 0, r0, c8, c7, 0	/* flush v4 TLB */
	mov	pc, lr

	.global hogcpu
hogcpu:
	mov	r0, #2000		/* we get the outer loop r0 as input */
1:
	mov	r1, #2000		/* inner loops amount */
2:
	subs	r1, r1, #1
	bne	2b
	subs	r0, r0, #1
	bne	1b
	mov	pc, lr

	.global reboot
reboot:
	mrs	r0, cpsr		/* turn off interrupts */
	bic	r0, r0, #0xdf
	orr	r0, r0, #0xd3		/* disable FIQ, IRQ, set SVC mode */
	msr	cpsr, r0
	mov	r0, #0xc0000000		/* load r0 with physical map address */
	mov	r1, #070		/* turn off MMU */
	mcr	p15, 0, r1, c1, c1
	mov	r15, #0

	.global bootlinux		/* r0: kernel r1: kernel arch no */
bootlinux:
	mov	r6, r0
	mov	r0, #0
	mov	pc, r6			/* Jump to Linux */
	.end


